/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TheNightOfTheDoctorEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>(Arrays.asList("First strike", "Vigilance", "Lifelink"));

    TheNightOfTheDoctorEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return target legendary creature card from your graveyard to the battlefield. Put your choice of a first strike, vigilance, or lifelink counter on it";
    }

    private TheNightOfTheDoctorEffect(TheNightOfTheDoctorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheNightOfTheDoctorEffect copy() {
        return new TheNightOfTheDoctorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null || !controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose first strike, vigilance, or lifelink counter");
        choice.setChoices(choices);
        controller.choose(this.outcome, (Choice)choice, game);
        String chosen = choice.getChoice();
        if (chosen != null) {
            permanent.addCounters(CounterType.findByName((String)chosen.toLowerCase(Locale.ENGLISH)).createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

