/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class TheNiptonLotteryEffect
extends OneShotEffect {
    TheNiptonLotteryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a creature at random. You gain control of that creature until end of turn. Untap it. It gains haste until end of turn. Then destroy all other creatures.";
    }

    private TheNiptonLotteryEffect(TheNiptonLotteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List creatureList = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        if (creatureList.isEmpty()) {
            return true;
        }
        Permanent permanentToSteal = (Permanent)creatureList.get(RandomUtil.nextInt((int)creatureList.size()));
        GainControlTargetEffect controlEffect = new GainControlTargetEffect(Duration.EndOfTurn);
        controlEffect.setTargetPointer((TargetPointer)new FixedTarget(permanentToSteal, game));
        game.addEffect((ContinuousEffect)controlEffect, source);
        game.processAction();
        permanentToSteal.untap(game);
        GainAbilityTargetEffect hasteEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
        hasteEffect.setTargetPointer((TargetPointer)new FixedTarget(permanentToSteal, game));
        game.addEffect((ContinuousEffect)hasteEffect, source);
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(permanentToSteal.getId())));
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }

    public TheNiptonLotteryEffect copy() {
        return new TheNiptonLotteryEffect(this);
    }
}

