/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.t.TheSeaDevilsEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.GameLog;

class TheSeaDevilsTrigger
extends DelayedTriggeredAbility {
    private static final FilterPermanent filter = new FilterPermanent(SubType.SALAMANDER, "Salamander");

    TheSeaDevilsTrigger() {
        super((Effect)new TheSeaDevilsEffect(), Duration.EndOfTurn, false);
    }

    private TheSeaDevilsTrigger(TheSeaDevilsTrigger ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public TheSeaDevilsTrigger copy() {
        return new TheSeaDevilsTrigger(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedPlayerEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent salamander = game.getPermanent(event.getSourceId());
        if (!filter.match(salamander, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        Player player = game.getPlayer(event.getTargetId());
        MageObjectReference salamanderMOR = new MageObjectReference((MageObject)salamander, game);
        if (salamanderMOR == null || player == null) {
            return false;
        }
        this.getTargets().clear();
        FilterCreaturePermanent filterTarget = new FilterCreaturePermanent("creature " + player.getName() + " controls");
        filterTarget.add((Predicate)new ControllerIdPredicate(player.getId()));
        this.addTarget((Target)new TargetPermanent((FilterPermanent)filterTarget));
        int amount = event.getAmount();
        this.getEffects().setValue("damage", (Object)amount);
        this.getEffects().setValue("sourceMOR", (Object)salamanderMOR);
        for (Effect effect : this.getEffects()) {
            if (!(effect instanceof TheSeaDevilsEffect)) continue;
            effect.setTargetPointer(new FixedTarget(event.getSourceId(), game).withData("damageAmount", "" + amount).withData("triggeredName", GameLog.getColoredObjectIdNameForTooltip((MageObject)salamander)));
        }
        return true;
    }

    public String getRule() {
        String triggeredInfo = "";
        String triggeredDamage = ((Effect)this.getEffects().get(0)).getTargetPointer().getData("damageAmount");
        if (!triggeredDamage.isEmpty()) {
            triggeredInfo = triggeredInfo + "<br><i>Damage: " + ((Effect)this.getEffects().get(0)).getTargetPointer().getData("damageAmount") + "</i>";
            triggeredInfo = triggeredInfo + "<br><i>Salamander: " + ((Effect)this.getEffects().get(0)).getTargetPointer().getData("triggeredName") + "</i>";
        }
        return "Until end of turn, whenever a Salamander deals combat damage to a player, it deals that much damage to target creature that player controls." + triggeredInfo;
    }
}

