/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ArtifactYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class TheSeventhDoctorEffect
extends OneShotEffect {
    TheSeventhDoctorEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a card in your hand. Defending player guesses whether that card's mana value is greater than the number of artifacts you control. If they guessed wrong, you may cast it without paying its mana cost. If you don't cast a spell this way, investigate";
    }

    private TheSeventhDoctorEffect(TheSeventhDoctorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheSeventhDoctorEffect copy() {
        return new TheSeventhDoctorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.getHand().isEmpty()) {
            InvestigateEffect.doInvestigate((UUID)source.getControllerId(), (int)1, (Game)game, (Ability)source);
            return true;
        }
        TargetCardInHand target = new TargetCardInHand();
        controller.choose(Outcome.PlayForFree, controller.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        game.informPlayers(controller.getLogName() + " has chosen a card in their hand");
        Player defender = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (defender == null || card == null) {
            InvestigateEffect.doInvestigate((UUID)source.getControllerId(), (int)1, (Game)game, (Ability)source);
            return true;
        }
        int count = ArtifactYouControlCount.instance.calculate(game, source, (Effect)this);
        boolean guessedGreater = defender.chooseUse(this.outcome, "Is the chosen card's mana value greater than the number of artifacts " + controller.getName() + " controls?", controller.getName() + " controls " + count + " artifacts", "Greater than", "Not greater than", source, game);
        game.informPlayers(defender.getLogName() + " has guessed that the chosen card's mana value is " + (guessedGreater ? "" : "not ") + "greater than the number of artifacts controlled by " + controller.getLogName());
        if (card.getManaValue() > count == guessedGreater || !CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card)) {
            InvestigateEffect.doInvestigate((UUID)source.getControllerId(), (int)1, (Game)game, (Ability)source);
        }
        return true;
    }
}

