/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheSkullsporeNexusDoubleEffect
extends OneShotEffect {
    TheSkullsporeNexusDoubleEffect() {
        super(Outcome.Benefit);
        this.staticText = "double target creature's power until end of turn";
    }

    private TheSkullsporeNexusDoubleEffect(TheSkullsporeNexusDoubleEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheSkullsporeNexusDoubleEffect copy() {
        return new TheSkullsporeNexusDoubleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        ContinuousEffect boost = new BoostTargetEffect(permanent.getPower().getValue(), 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect(boost, source);
        return true;
    }
}

