/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.token.FungusDinosaurToken;
import mage.game.permanent.token.Token;

class TheSkullsporeNexusTrigger
extends TriggeredAbilityImpl {
    private static final String infoKey = "totalpower";

    TheSkullsporeNexusTrigger() {
        super(Zone.BATTLEFIELD, null, false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private TheSkullsporeNexusTrigger(TheSkullsporeNexusTrigger ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TheSkullsporeNexusTrigger copy() {
        return new TheSkullsporeNexusTrigger(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        List permanents = zEvent.getCards().stream().map(MageItem::getId).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).filter(Objects::nonNull).filter(p -> p.isCreature(game) && p.isControlledBy(this.getControllerId())).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        int amount = permanents.stream().mapToInt(p -> p.getPower().getValue()).sum();
        this.getEffects().clear();
        CreateTokenEffect effect = new CreateTokenEffect((Token)new FungusDinosaurToken(amount));
        effect.setValue(infoKey, (Object)amount);
        this.getEffects().add((Object)effect);
        return true;
    }

    public String getRule() {
        String triggeredInfo = "";
        if (!this.getEffects().isEmpty()) {
            triggeredInfo = triggeredInfo + "<br><br><i>Total power: " + ((Effect)this.getEffects().get(0)).getValue(infoKey) + "</i>";
        }
        return "Whenever one or more nontoken creatures you control die, create a green Fungus Dinosaur creature token with base power and toughness each equal to the total power of those creatures." + triggeredInfo;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

