/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class TheTarrasqueWatcher
extends Watcher {
    private final Set<MageObjectReference> cast = new HashSet<MageObjectReference>();

    TheTarrasqueWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: {
                Spell spell = game.getSpell(event.getTargetId());
                if (spell != null) {
                    this.cast.add(new MageObjectReference((MageObject)spell.getCard(), game, 1));
                }
                return;
            }
            case BEGINNING_PHASE_PRE: {
                if (game.getTurnNum() != 1) break;
                this.cast.clear();
            }
        }
    }

    static boolean checkSource(Game game, Ability source) {
        TheTarrasqueWatcher watcher = (TheTarrasqueWatcher)game.getState().getWatcher(TheTarrasqueWatcher.class);
        return watcher != null && watcher.cast.stream().anyMatch(mor -> mor.refersTo((MageObject)source.getSourcePermanentIfItStillExists(game), game));
    }
}

