/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class TheTemporalAnchorPlayEffect
extends AsThoughEffectImpl {
    TheTemporalAnchorPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "during your turn, you may play cards exiled with {this}";
    }

    private TheTemporalAnchorPlayEffect(TheTemporalAnchorPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public TheTemporalAnchorPlayEffect copy() {
        return new TheTemporalAnchorPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || !game.isActivePlayer(affectedControllerId)) {
            return false;
        }
        Card card = game.getCard(objectId);
        if (card == null) {
            return false;
        }
        UUID mainId = card.getMainCard().getId();
        MageObject sourceObject = source.getSourceObject(game);
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game)));
        return exileZone != null && exileZone.contains((Object)mainId) && game.getCard(mainId) != null;
    }
}

