/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ClueArtifactToken;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class TheThirdDoctorEffect
extends OneShotEffect {
    private static final Set<String> choices = new HashSet<String>();

    public TheThirdDoctorEffect() {
        super(Outcome.Benefit);
        this.staticText = "create your choice of a Clue token, a Food token, or a Treasure token";
    }

    private TheThirdDoctorEffect(TheThirdDoctorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChoiceImpl choiceImpl = new ChoiceImpl(true);
        choiceImpl.setMessage("Choose type of token to create");
        choiceImpl.setChoices(choices);
        if (controller.choose(this.outcome, (Choice)choiceImpl, game)) {
            ClueArtifactToken token;
            switch (choiceImpl.getChoice()) {
                case "Clue": {
                    token = new ClueArtifactToken();
                    break;
                }
                case "Food": {
                    token = new FoodToken();
                    break;
                }
                default: {
                    token = new TreasureToken();
                }
            }
            return token.putOntoBattlefield(1, game, source, source.getControllerId());
        }
        return false;
    }

    public TheThirdDoctorEffect copy() {
        return new TheThirdDoctorEffect(this);
    }

    static {
        choices.add("Clue");
        choices.add("Food");
        choices.add("Treasure");
    }
}

