/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.WarriorToken;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TheWarGamesEffect
extends OneShotEffect {
    TheWarGamesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player creates three tapped 1/1 white Warrior creature tokens. The tokens are goaded for as long as {this} remains on the battlefield";
    }

    private TheWarGamesEffect(TheWarGamesEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheWarGamesEffect copy() {
        return new TheWarGamesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet addedTokens = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            WarriorToken token = new WarriorToken();
            token.putOntoBattlefield(3, game, source, playerId, true, false);
            addedTokens.addAll(token.getLastAddedTokenIds());
        }
        if (addedTokens.isEmpty()) {
            return false;
        }
        if (source.getSourceObjectIfItStillExists(game) != null) {
            game.addEffect(new GoadTargetEffect(Duration.UntilSourceLeavesBattlefield).setTargetPointer((TargetPointer)new FixedTargets((Collection)addedTokens.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet()), game)), source);
        }
        return true;
    }
}

