/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class TheWarInHeavenEffect
extends OneShotEffect {
    TheWarInHeavenEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to three target creature cards with total mana value 8 or less in your graveyard. Return each of them to the battlefield with a necrodermis counter on it. They're artifacts in addition to their other types";
    }

    private TheWarInHeavenEffect(TheWarInHeavenEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheWarInHeavenEffect copy() {
        return new TheWarInHeavenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List targetIds = this.getTargetPointer().getTargets(game, source);
        for (UUID targetId : targetIds) {
            Card card = game.getCard(targetId);
            if (card == null) continue;
            card.moveToZone(Zone.BATTLEFIELD, source, game, false);
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.NECRODERMIS.createInstance(), source, game);
            game.addEffect(new AddCardTypeTargetEffect(Duration.Custom, new CardType[]{CardType.ARTIFACT}).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

