/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class TheWorldSpellEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard("non-Saga permanent cards");

    TheWorldSpellEffect() {
        super(Outcome.Benefit);
        this.staticText = "put up to two non-Saga permanent cards from your hand onto the battlefield";
    }

    private TheWorldSpellEffect(TheWorldSpellEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheWorldSpellEffect copy() {
        return new TheWorldSpellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 2, filter);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        return player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.SAGA.getPredicate()));
    }
}

