/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.PlayerLostLifeWatcher;

class TheaterOfHorrorsCastEffect
extends AsThoughEffectImpl {
    TheaterOfHorrorsCastEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "during your turn, if an opponent lost life this turn, you may play lands and cast spells from among cards exiled with {this}";
    }

    private TheaterOfHorrorsCastEffect(TheaterOfHorrorsCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public TheaterOfHorrorsCastEffect copy() {
        return new TheaterOfHorrorsCastEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card theCard = game.getCard(objectId);
        if (theCard == null) {
            return false;
        }
        objectId = theCard.getMainCard().getId();
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (watcher != null && game.isActivePlayer(source.getControllerId()) && watcher.getAllOppLifeLost(source.getControllerId(), game) > 0 && affectedControllerId.equals(source.getControllerId()) && game.getState().getZone(objectId) == Zone.EXILED) {
            ExileZone exileZone = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)source));
            return exileZone != null && exileZone.contains((Object)objectId);
        }
        return false;
    }
}

