/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThermalFluxEffect
extends ContinuousEffectImpl {
    private final boolean addSnow;

    public ThermalFluxEffect(boolean addSnow) {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.addSnow = addSnow;
        this.staticText = "Target " + (addSnow ? "non" : "") + "snow permanent " + (addSnow ? "becomes" : "isn't") + " snow until end of turn";
    }

    private ThermalFluxEffect(ThermalFluxEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.addSnow = effect.addSnow;
    }

    public ThermalFluxEffect copy() {
        return new ThermalFluxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            if (this.addSnow) {
                permanent.addSuperType(game, SuperType.SNOW);
            } else {
                permanent.removeSuperType(game, SuperType.SNOW);
            }
        }
        return true;
    }
}

