/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class ThespiansStageCopyEffect
extends OneShotEffect {
    ThespiansStageCopyEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a copy of target land, except it has this ability";
    }

    private ThespiansStageCopyEffect(ThespiansStageCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThespiansStageCopyEffect copy() {
        return new ThespiansStageCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            Permanent newPermanent = game.copyPermanent(copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new ThespiansStageCopyEffect(), (Cost)new GenericManaCost(2));
            ability.addCost((Cost)new TapSourceCost());
            ability.addTarget((Target)new TargetLandPermanent());
            newPermanent.addAbility((Ability)ability, source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

