/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThiefOfExistenceTargetEffect
extends OneShotEffect {
    ThiefOfExistenceTargetEffect() {
        super(Outcome.Exile);
        this.staticText = "exile up to one target noncreature, nonland permanent an opponent controls with mana value 4 or less. If you do, {this} gains \"When this creature leaves the battlefield, target opponent draws a card.\"";
    }

    private ThiefOfExistenceTargetEffect(ThiefOfExistenceTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThiefOfExistenceTargetEffect copy() {
        return new ThiefOfExistenceTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (!permanent.moveToExile(null, null, source, game)) {
            return true;
        }
        Spell sourceSpell = (Spell)source.getSourceCardIfItStillExists(game);
        if (sourceSpell == null) {
            return true;
        }
        LeavesBattlefieldTriggeredAbility trigger = new LeavesBattlefieldTriggeredAbility((Effect)new DrawCardTargetEffect(1));
        trigger.addTarget((Target)new TargetOpponent());
        game.addEffect(new GainAbilityTargetEffect((Ability)trigger, Duration.Custom, "", true).setTargetPointer((TargetPointer)new FixedTarget(sourceSpell.getCard(), game)), source);
        return true;
    }
}

