/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ThornmantleStrikerEffect
extends OneShotEffect {
    private final DynamicValue xValue;

    ThornmantleStrikerEffect(DynamicValue xValue) {
        super(Outcome.AIDontUseIt);
        this.staticText = "Remove X counters from target permanent, where X is the number of Elves you control";
        this.xValue = xValue;
    }

    private ThornmantleStrikerEffect(ThornmantleStrikerEffect effect) {
        super((OneShotEffect)effect);
        this.xValue = effect.xValue.copy();
    }

    public ThornmantleStrikerEffect copy() {
        return new ThornmantleStrikerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null) {
            return false;
        }
        int elves = this.xValue.calculate(game, source, (Effect)this);
        if (elves < 1) {
            return false;
        }
        Counters counters = permanent.getCounters(game).copy();
        int totalCounters = 0;
        for (Counter counter : counters.values()) {
            totalCounters += counter.getCount();
        }
        if (totalCounters == 0) {
            return false;
        }
        if (totalCounters <= elves) {
            for (Map.Entry entry : counters.entrySet()) {
                permanent.removeCounters((String)entry.getKey(), ((Counter)entry.getValue()).getCount(), source, game);
            }
            return true;
        }
        if (counters.size() == 1) {
            String counterName = (String)counters.keySet().iterator().next();
            permanent.removeCounters(counterName, elves, source, game);
            return true;
        }
        int remainingCounters = totalCounters;
        int countersLeftToRemove = elves;
        for (Map.Entry entry : counters.entrySet()) {
            String counterName = (String)entry.getKey();
            int numCounters = ((Counter)entry.getValue()).getCount();
            int min = Math.max(0, countersLeftToRemove - (remainingCounters -= numCounters));
            int max = Math.min(countersLeftToRemove, numCounters);
            int toRemove = controller.getAmount(min, max, counterName + " counters to remove", source, game);
            toRemove = Math.max(toRemove, min);
            toRemove = Math.min(toRemove, max);
            permanent.removeCounters(counterName, toRemove, source, game);
            if ((countersLeftToRemove -= toRemove) > 0) continue;
            break;
        }
        return true;
    }
}

