/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ThoughtCollapseEffect
extends OneShotEffect {
    private static final Effect effect = new CounterTargetEffect();

    ThoughtCollapseEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. Its controller mills three cards";
    }

    private ThoughtCollapseEffect(ThoughtCollapseEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtCollapseEffect copy() {
        return new ThoughtCollapseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getControllerId(source.getFirstTarget()));
        if (player == null) {
            return false;
        }
        player.millCards(3, source, game);
        return effect.apply(game, source);
    }
}

