/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ThoughtpickerWitchEffect
extends OneShotEffect {
    ThoughtpickerWitchEffect() {
        super(Outcome.Exile);
        this.staticText = "Look at the top two cards of target opponent's library, then exile one of them";
    }

    private ThoughtpickerWitchEffect(ThoughtpickerWitchEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtpickerWitchEffect copy() {
        return new ThoughtpickerWitchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && opponent != null) {
            Card card;
            TargetCardInLibrary target;
            CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 2));
            if (!cards.isEmpty() && controller.choose(Outcome.Exile, (Cards)cards, (TargetCard)(target = new TargetCardInLibrary(new FilterCard("card to exile"))), source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                cards.remove(card);
                opponent.moveCards(card, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }
}

