/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ThoughtsOfRuinEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent();

    public ThoughtsOfRuinEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player sacrifices a land for each card in your hand";
    }

    private ThoughtsOfRuinEffect(ThoughtsOfRuinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtsOfRuinEffect copy() {
        return new ThoughtsOfRuinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (amount = controller.getHand().size()) > 0) {
            ArrayList<Permanent> permanentsToSacrifice = new ArrayList<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int lands = game.getBattlefield().countAll((FilterPermanent)filter, playerId, game);
                if (amount >= lands) {
                    permanentsToSacrifice.addAll(game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game));
                    continue;
                }
                FilterLandPermanent playerFilter = filter.copy();
                playerFilter.add((Predicate)new ControllerIdPredicate(playerId));
                TargetPermanent target = new TargetPermanent(amount, amount, (FilterPermanent)playerFilter, true);
                player.choose(this.outcome, (Target)target, source, game);
                for (UUID landId : target.getTargets()) {
                    Permanent permanent = game.getPermanent(landId);
                    if (permanent == null) continue;
                    permanentsToSacrifice.add(permanent);
                }
            }
            for (Permanent permanent : permanentsToSacrifice) {
                permanent.sacrifice(source, game);
            }
        }
        return false;
    }
}

