/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class ThousandYearStormEffect
extends OneShotEffect {
    private int stormCount;

    public ThousandYearStormEffect() {
        super(Outcome.Benefit);
        this.stormCount = -1;
        this.staticText = "copy it for each other instant and sorcery spell you've cast before it this turn. You may choose new targets for the copies";
    }

    private ThousandYearStormEffect(ThousandYearStormEffect effect) {
        super((OneShotEffect)effect);
        this.stormCount = effect.stormCount;
    }

    public ThousandYearStormEffect copy() {
        return new ThousandYearStormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (this.stormCount >= 0 && spell != null) {
            spell.createCopyOnStack(game, source, source.getControllerId(), true, this.stormCount);
            return true;
        }
        return false;
    }

    public void setStormCount(int stormCount) {
        this.stormCount = stormCount;
    }
}

