/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BasicManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThranPortalManaAbilityContinuousEffect
extends ContinuousEffectImpl {
    private static final Map<SubType, BasicManaAbility> abilityMap = new HashMap<SubType, BasicManaAbility>(){
        {
            this.put(SubType.PLAINS, new WhiteManaAbility());
            this.put(SubType.ISLAND, new BlueManaAbility());
            this.put(SubType.SWAMP, new BlackManaAbility());
            this.put(SubType.MOUNTAIN, new RedManaAbility());
            this.put(SubType.FOREST, new GreenManaAbility());
        }
    };

    public ThranPortalManaAbilityContinuousEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "{this} is the chosen type in addition to its other types.";
    }

    private ThranPortalManaAbilityContinuousEffect(ThranPortalManaAbilityContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ThranPortalManaAbilityContinuousEffect copy() {
        return new ThranPortalManaAbilityContinuousEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
        if (choice == null) {
            this.discard();
            return;
        }
        switch (choice) {
            case FOREST: {
                this.dependencyTypes.add(DependencyType.BecomeForest);
                break;
            }
            case PLAINS: {
                this.dependencyTypes.add(DependencyType.BecomePlains);
                break;
            }
            case MOUNTAIN: {
                this.dependencyTypes.add(DependencyType.BecomeMountain);
                break;
            }
            case ISLAND: {
                this.dependencyTypes.add(DependencyType.BecomeIsland);
                break;
            }
            case SWAMP: {
                this.dependencyTypes.add(DependencyType.BecomeSwamp);
                break;
            }
            default: {
                throw new RuntimeException("Incorrect mana choice " + choice + "for Thran Portal");
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent thranPortal = game.getPermanent(source.getSourceId());
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
        if (thranPortal == null || choice == null) {
            return false;
        }
        if (!thranPortal.hasSubtype(choice, game)) {
            thranPortal.addSubType(new SubType[]{choice});
        }
        if (!thranPortal.hasAbility((Ability)abilityMap.get(choice), game)) {
            thranPortal.addAbility((Ability)abilityMap.get(choice), source.getId(), game);
        }
        return true;
    }
}

