/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.t.ThreatsUndetectedTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetOpponent;

class ThreatsUndetectedEffect
extends OneShotEffect {
    ThreatsUndetectedEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to four creature cards with different powers and reveal them. An opponent chooses two of those cards. Shuffle the chosen cards into your library and put the rest into your hand.";
    }

    private ThreatsUndetectedEffect(ThreatsUndetectedEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThreatsUndetectedEffect copy() {
        return new ThreatsUndetectedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object target;
        Player opponent;
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        Set opponents = game.getOpponents(controllerId);
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            target = new TargetOpponent(true);
            controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            opponent = game.getPlayer(target.getFirstTarget());
        }
        if (opponent == null) {
            return false;
        }
        target = new ThreatsUndetectedTarget();
        controller.searchLibrary((TargetCardInLibrary)target, source, game);
        CardsImpl searchedCards = new CardsImpl((Collection)target.getTargets());
        if (searchedCards.isEmpty()) {
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.revealCards(source, (Cards)searchedCards, game);
        TargetCard opponentTarget = new TargetCard(Math.min(searchedCards.size(), 2), Zone.LIBRARY, StaticFilters.FILTER_CARD);
        opponentTarget.withChooseHint("to be shuffled into opponent's library");
        opponent.chooseTarget(Outcome.Benefit, (Cards)searchedCards, opponentTarget, source, game);
        CardsImpl chosenCards = new CardsImpl((Collection)opponentTarget.getTargets());
        if (chosenCards.isEmpty()) {
            controller.shuffleLibrary(source, game);
        } else {
            searchedCards.removeAll((Collection)chosenCards);
            controller.shuffleCardsToLibrary((Cards)chosenCards, game, source);
        }
        controller.moveCards((Cards)searchedCards, Zone.HAND, source, game);
        return true;
    }
}

