/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class ThreeWishesLookAtCardEffect
extends AsThoughEffectImpl {
    ThreeWishesLookAtCardEffect() {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may look at cards exiled with {this} as long as they remain exiled";
    }

    private ThreeWishesLookAtCardEffect(ThreeWishesLookAtCardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ThreeWishesLookAtCardEffect copy() {
        return new ThreeWishesLookAtCardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        if (affectedControllerId.equals(source.getControllerId()) && (card = game.getCard(objectId)) != null) {
            MageObject sourceObject = game.getObject(source);
            if (sourceObject == null) {
                return false;
            }
            UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)0);
            ExileZone exile = game.getExile().getExileZone(exileId);
            return exile != null && exile.contains((Object)card.getId());
        }
        return false;
    }
}

