/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.t.ThroneOfEldraineCondition;
import mage.cards.t.ThroneOfEldraineManaBuilder;
import mage.game.Game;

class ThroneOfEldraineManaEffect
extends ManaEffect {
    private static final ThroneOfEldraineManaBuilder buildWhite = new ThroneOfEldraineManaBuilder(ThroneOfEldraineCondition.white);
    private static final ThroneOfEldraineManaBuilder buildBlue = new ThroneOfEldraineManaBuilder(ThroneOfEldraineCondition.blue);
    private static final ThroneOfEldraineManaBuilder buildBlack = new ThroneOfEldraineManaBuilder(ThroneOfEldraineCondition.black);
    private static final ThroneOfEldraineManaBuilder buildRed = new ThroneOfEldraineManaBuilder(ThroneOfEldraineCondition.red);
    private static final ThroneOfEldraineManaBuilder buildGreen = new ThroneOfEldraineManaBuilder(ThroneOfEldraineCondition.green);
    private ObjectColor chosenColorInfo = null;

    ThroneOfEldraineManaEffect() {
        this.staticText = "Add four mana of the chosen color. Spend this mana only to cast monocolored spells of that color";
    }

    private ThroneOfEldraineManaEffect(ThroneOfEldraineManaEffect effect) {
        super((ManaEffect)effect);
        this.chosenColorInfo = effect.chosenColorInfo;
    }

    public ThroneOfEldraineManaEffect copy() {
        return new ThroneOfEldraineManaEffect(this);
    }

    public Mana produceMana(Game game, Ability source) {
        ObjectColor color;
        if (game != null && (color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color")) != null) {
            this.chosenColorInfo = color;
            if (color.isWhite()) {
                return (Mana)buildWhite.setMana(Mana.WhiteMana((int)4), source, game).build(new Object[0]);
            }
            if (color.isBlue()) {
                return (Mana)buildBlue.setMana(Mana.BlueMana((int)4), source, game).build(new Object[0]);
            }
            if (color.isBlack()) {
                return (Mana)buildBlack.setMana(Mana.BlackMana((int)4), source, game).build(new Object[0]);
            }
            if (color.isRed()) {
                return (Mana)buildRed.setMana(Mana.RedMana((int)4), source, game).build(new Object[0]);
            }
            if (color.isGreen()) {
                return (Mana)buildGreen.setMana(Mana.GreenMana((int)4), source, game).build(new Object[0]);
            }
        }
        return new Mana();
    }
}

