/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInGraveyardBattlefieldOrStack;

class ThroneOfTheGrimCaptainTarget
extends TargetCardInGraveyardBattlefieldOrStack {
    private static final FilterCard filterCard = new FilterCard("a Dinosaur, a Merfolk, a Pirate, or Vampire card");
    private static final FilterPermanent filterPermanent = new FilterControlledPermanent("another Dinosaur, a Merfolk, a Pirate, or Vampire you control");
    private static final Predicate<MageObject> predicate = Predicates.or((Predicate[])new Predicate[]{SubType.PIRATE.getPredicate(), SubType.VAMPIRE.getPredicate(), SubType.DINOSAUR.getPredicate(), SubType.MERFOLK.getPredicate()});
    private static final SubTypeAssignment subtypeAssigner;

    ThroneOfTheGrimCaptainTarget() {
        super(4, 4, filterCard, filterPermanent);
    }

    private ThroneOfTheGrimCaptainTarget(ThroneOfTheGrimCaptainTarget target) {
        super((TargetCardInGraveyardBattlefieldOrStack)target);
    }

    public ThroneOfTheGrimCaptainTarget copy() {
        return new ThroneOfTheGrimCaptainTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Set cards = this.getTargets().stream().map(uuid -> {
            Permanent permanent = game.getPermanent(uuid);
            if (permanent != null) {
                return permanent;
            }
            return game.getCard(uuid);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return subtypeAssigner.getRoleCount(cards, game) <= 4;
    }

    static {
        filterCard.add(predicate);
        filterCard.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
        filterPermanent.add(predicate);
        filterPermanent.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        subtypeAssigner = new SubTypeAssignment(new SubType[]{SubType.PIRATE, SubType.VAMPIRE, SubType.DINOSAUR, SubType.MERFOLK});
    }
}

