/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ThunderstaffPreventionEffect
extends PreventionEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public ThunderstaffPreventionEffect() {
        super(Duration.WhileOnBattlefield, 1, true, false);
        this.staticText = "As long as {this} is untapped, if a creature would deal combat damage to you, prevent 1 of that damage";
    }

    private ThunderstaffPreventionEffect(ThunderstaffPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public ThunderstaffPreventionEffect copy() {
        return new ThunderstaffPreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent damageSource;
        Permanent sourcePermanent;
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId()) && (sourcePermanent = game.getPermanent(source.getSourceId())) != null && !sourcePermanent.isTapped() && (damageSource = game.getPermanent(event.getSourceId())) != null && filter.match((Object)damageSource, game);
    }
}

