/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TidalWaveWallToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TidalWaveEffect
extends OneShotEffect {
    TidalWaveEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 5/5 blue Wall creature token with defender. Sacrifice it at the beginning of the next end step.";
    }

    private TidalWaveEffect(TidalWaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public TidalWaveEffect copy() {
        return new TidalWaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TidalWaveWallToken token = new TidalWaveWallToken();
        if (token.putOntoBattlefield(1, game, source, source.getControllerId())) {
            for (UUID tokenId : token.getLastAddedTokenIds()) {
                Permanent tokenPermanent = game.getPermanent(tokenId);
                if (tokenPermanent == null) continue;
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect();
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenPermanent, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect), source);
            }
            return true;
        }
        return false;
    }
}

