/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class TimberpackWolf
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("other creature you control named Timberpack Wolf");

    public TimberpackWolf(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{G}");
        this.subtype.add((Object)SubType.WOLF);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new TimberpackWolfEffect()));
    }

    private TimberpackWolf(TimberpackWolf card) {
        super((CardImpl)card);
    }

    public TimberpackWolf copy() {
        return new TimberpackWolf(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Timberpack Wolf"));
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }

    static class TimberpackWolfEffect
    extends ContinuousEffectImpl {
        public TimberpackWolfEffect() {
            super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
            this.staticText = "{this} gets +1/+1 for each other creature you control named Timberpack Wolf";
        }

        private TimberpackWolfEffect(TimberpackWolfEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public TimberpackWolfEffect copy() {
            return new TimberpackWolfEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent target;
            int count = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) - 1;
            if (count > 0 && (target = game.getPermanent(source.getSourceId())) != null) {
                target.addPower(count);
                target.addToughness(count);
                return true;
            }
            return false;
        }
    }
}

