/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TimeSpiralEffect
extends OneShotEffect {
    TimeSpiralEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player shuffles their hand and graveyard into their library";
    }

    private TimeSpiralEffect(TimeSpiralEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            CardsImpl toLib = new CardsImpl((Collection)player.getHand());
            toLib.addAll((Collection)player.getGraveyard());
            player.shuffleCardsToLibrary((Cards)toLib, game, source);
        }
        return true;
    }

    public TimeSpiralEffect copy() {
        return new TimeSpiralEffect(this);
    }
}

