/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TimebenderEffect
extends OneShotEffect {
    private final boolean addCounters;

    TimebenderEffect(boolean addCounters) {
        super(Outcome.Benefit);
        this.addCounters = addCounters;
        this.staticText = addCounters ? "put two time counters on target permanent with a time counter on it or suspended card" : "remove two time counters from target permanent or suspended card";
    }

    private TimebenderEffect(TimebenderEffect effect) {
        super((OneShotEffect)effect);
        this.addCounters = effect.addCounters;
    }

    public TimebenderEffect copy() {
        return new TimebenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            if (this.addCounters) {
                permanent.addCounters(CounterType.TIME.createInstance(2), source.getControllerId(), source, game);
            } else {
                permanent.removeCounters(CounterType.TIME.getName(), 2, source, game);
            }
            return true;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            if (this.addCounters) {
                card.addCounters(CounterType.TIME.createInstance(2), source.getControllerId(), source, game);
            } else {
                card.removeCounters(CounterType.TIME.getName(), 2, source, game);
            }
            return true;
        }
        return false;
    }
}

