/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.LoseAllAbilitiesTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TishanasTidebinderEffect
extends OneShotEffect {
    TishanasTidebinderEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter up to one target activated or triggered ability. If an ability of an artifact, creature, or planeswalker is countered this way, that permanent loses all abilities for as long as {this} remains on the battlefield";
    }

    private TishanasTidebinderEffect(TishanasTidebinderEffect effect) {
        super((OneShotEffect)effect);
    }

    public TishanasTidebinderEffect copy() {
        return new TishanasTidebinderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(stackObject.getSourceId());
        game.getStack().counter(stackObject.getId(), source, game);
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || sourcePermanent == null || !permanent.isArtifact(game) && !permanent.isCreature(game) && !permanent.isPlaneswalker(game)) {
            return true;
        }
        game.addEffect(new LoseAllAbilitiesTargetEffect(Duration.UntilSourceLeavesBattlefield).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

