/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TitaniasCommandEffect
extends OneShotEffect {
    TitaniasCommandEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target player's graveyard. You gain 1 life for each card exiled this way";
    }

    private TitaniasCommandEffect(TitaniasCommandEffect effect) {
        super((OneShotEffect)effect);
    }

    public TitaniasCommandEffect copy() {
        return new TitaniasCommandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)player.getGraveyard());
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        controller.gainLife(cards.size(), game, source);
        return true;
    }
}

