/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class TitheEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Plains");

    TitheEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a Plains card. If target opponent controls more lands than you, you may search your library for an additional Plains card. Reveal those cards, put them into your hand, then shuffle";
    }

    private TitheEffect(TitheEffect effect) {
        super((OneShotEffect)effect);
    }

    public TitheEffect copy() {
        return new TitheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int numYourLands = game.getBattlefield().countAll((FilterPermanent)new FilterLandPermanent(), source.getControllerId(), game);
        int numOpponentLands = game.getBattlefield().countAll((FilterPermanent)new FilterLandPermanent(), this.getTargetPointer().getFirst(game, source), game);
        new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, numOpponentLands > numYourLands ? 2 : 1, filter), true).apply(game, source);
        return true;
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

