/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.DemonFlyingToken;
import mage.players.Player;
import mage.watchers.common.PlayerGainedLifeWatcher;

class TivashGloomSummonerEffect
extends OneShotEffect {
    TivashGloomSummonerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay X life, where X is the amount of life you gained this turn. If you do, create an X/X black Demon creature token with flying";
    }

    private TivashGloomSummonerEffect(TivashGloomSummonerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TivashGloomSummonerEffect copy() {
        return new TivashGloomSummonerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        PlayerGainedLifeWatcher watcher = (PlayerGainedLifeWatcher)game.getState().getWatcher(PlayerGainedLifeWatcher.class);
        if (player == null || watcher == null) {
            return false;
        }
        int lifeGained = watcher.getLifeGained(source.getControllerId());
        PayLifeCost cost = new PayLifeCost(lifeGained);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.PutCreatureInPlay, "Pay " + lifeGained + " life?", source, game) && cost.pay(source, game, source, source.getControllerId(), true))) {
            return false;
        }
        new DemonFlyingToken(lifeGained).putOntoBattlefield(1, game, source, source.getControllerId());
        return true;
    }
}

