/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.EscapeAbility;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TizerusChargerEffect
extends OneShotEffect {
    TizerusChargerEffect() {
        super(Outcome.Benefit);
    }

    private TizerusChargerEffect(TizerusChargerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TizerusChargerEffect copy() {
        return new TizerusChargerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        SpellAbility spellAbility = (SpellAbility)this.getValue("sourceCastSpellAbility");
        if (!(spellAbility instanceof EscapeAbility) || !spellAbility.getSourceId().equals(source.getSourceId()) || permanent.getZoneChangeCounter(game) != spellAbility.getStackMomentSourceZCC()) {
            return false;
        }
        ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
        CounterType counterType = player.chooseUse(this.outcome, "Choose +1/+1 or flying", null, "+1/+1", "Flying", source, game) ? CounterType.P1P1 : CounterType.FLYING;
        permanent.addCounters(counterType.createInstance(), source.getControllerId(), source, game, (List)appliedEffects);
        return true;
    }
}

