/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TogglodyteEntersEffect
extends OneShotEffect {
    TogglodyteEntersEffect() {
        super(Outcome.Neutral);
        this.staticText = "turned on";
    }

    private TogglodyteEntersEffect(TogglodyteEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (mageObject != null) {
            boolean toggled = true;
            game.getState().setValue(mageObject.getId() + "_toggle", (Object)toggled);
            if (mageObject instanceof Permanent) {
                mageObject.addInfo("toggle", CardUtil.addToolTipMarkTags((String)("Switch: " + (toggled ? "ON" : "OFF"))), game);
            }
            return true;
        }
        return false;
    }

    public TogglodyteEntersEffect copy() {
        return new TogglodyteEntersEffect(this);
    }
}

