/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class TolarianContemptEffect
extends OneShotEffect {
    TolarianContemptEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, choose up to one target creature they control with a rejection counter on it. That creature's owner puts it on the top or bottom of their library";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private TolarianContemptEffect(TolarianContemptEffect effect) {
        super((OneShotEffect)effect);
    }

    public TolarianContemptEffect copy() {
        return new TolarianContemptEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID creatureId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(creatureId);
            Player owner = game.getPlayer(game.getOwnerId(creatureId));
            if (permanent == null || owner == null) continue;
            if (owner.chooseUse(Outcome.Neutral, "Put " + permanent.getIdName() + " on the top or bottom of your library?", null, "Top", "Bottom", source, game)) {
                owner.putCardsOnTopOfLibrary((Card)permanent, game, source, false);
                continue;
            }
            owner.putCardsOnBottomOfLibrary((Card)permanent, game, source);
        }
        return true;
    }
}

