/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TolsimirFriendToWolvesEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;

class TolsimirFriendToWolvesTriggeredAbility
extends TriggeredAbilityImpl {
    TolsimirFriendToWolvesTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.addTarget((Target)new TargetOpponentsCreaturePermanent(0, 1));
    }

    private TolsimirFriendToWolvesTriggeredAbility(TolsimirFriendToWolvesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isControlledBy(this.getControllerId()) || !permanent.hasSubtype(SubType.WOLF, game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new TolsimirFriendToWolvesEffect(new MageObjectReference((MageObject)permanent, game)));
        return true;
    }

    public TolsimirFriendToWolvesTriggeredAbility copy() {
        return new TolsimirFriendToWolvesTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a Wolf you control enters, you gain 3 life and that creature fights up to one target creature an opponent controls.";
    }
}

