/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TolsimirMidnightsLightEffect
extends RequirementEffect {
    TolsimirMidnightsLightEffect() {
        super(Duration.EndOfCombat);
        this.staticText = "target creature an opponent controls blocks that Wolf this combat if able";
    }

    private TolsimirMidnightsLightEffect(TolsimirMidnightsLightEffect effect) {
        super((RequirementEffect)effect);
    }

    public TolsimirMidnightsLightEffect copy() {
        return new TolsimirMidnightsLightEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent attacker = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (attacker == null) {
            this.discard();
            return false;
        }
        return permanent != null && permanent.getId().equals(source.getFirstTarget()) && permanent.canBlock(this.getTargetPointer().getFirst(game, source), game);
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return false;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source);
    }
}

