/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TombstoneStairwellDestroyEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class TombstoneStairwellTriggeredAbility
extends TriggeredAbilityImpl {
    TombstoneStairwellTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TombstoneStairwellDestroyEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private TombstoneStairwellTriggeredAbility(TombstoneStairwellTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.END_TURN_STEP_PRE) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(this.sourceId);
            if (permanent != null) {
                for (Effect effect : this.getEffects()) {
                    if (effect instanceof TombstoneStairwellDestroyEffect) {
                        ((TombstoneStairwellDestroyEffect)effect).setCardZoneString(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)this.getSourceId(), (Game)game, (boolean)false));
                    }
                    if (!this.getTargets().isEmpty()) continue;
                    effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                }
                return true;
            }
        } else if (event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof TombstoneStairwellDestroyEffect)) continue;
                ((TombstoneStairwellDestroyEffect)effect).setCardZoneString(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)this.getSourceId(), (Game)game, (boolean)true));
            }
            return true;
        }
        return false;
    }

    public TombstoneStairwellTriggeredAbility copy() {
        return new TombstoneStairwellTriggeredAbility(this);
    }

    public String getRule() {
        return "At the beginning of each end step and when {this} leaves the battlefield, destroy all tokens created with {this}. They can't be regenerated.";
    }
}

