/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class TomikDistinguishedAdvokistRestrictionEffect
extends ContinuousRuleModifyingEffectImpl {
    TomikDistinguishedAdvokistRestrictionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't play land cards from graveyards";
    }

    private TomikDistinguishedAdvokistRestrictionEffect(TomikDistinguishedAdvokistRestrictionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TomikDistinguishedAdvokistRestrictionEffect copy() {
        return new TomikDistinguishedAdvokistRestrictionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.hasOpponent(event.getPlayerId(), game) && game.getState().getZone(event.getSourceId()) == Zone.GRAVEYARD;
    }
}

