/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeXTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class TorgaarFamineIncarnateEffectCostReductionEffect
extends CostModificationEffectImpl {
    TorgaarFamineIncarnateEffectCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "This spell costs {2} less to cast for each creature sacrificed this way";
    }

    private TorgaarFamineIncarnateEffectCostReductionEffect(TorgaarFamineIncarnateEffectCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof SacrificeXTargetCost)) continue;
            if (game.inCheckPlayableState()) {
                int reduction = ((SacrificeXTargetCost)cost).getMaxValue((Ability)spellAbility, game);
                CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
                break;
            }
            int reduction = ((SacrificeXTargetCost)cost).getAmount();
            CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
            break;
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }

    public TorgaarFamineIncarnateEffectCostReductionEffect copy() {
        return new TorgaarFamineIncarnateEffectCostReductionEffect(this);
    }
}

