/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class TorgalAFineHoundEffect
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent();
    private static final DynamicValue xValue;
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    TorgalAFineHoundEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
        this.staticText = "that creature enters with an additional +1/+1 counter on it for each Dog and/or Wolf you control";
    }

    private TorgalAFineHoundEffect(TorgalAFineHoundEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TorgalAFineHoundEffect copy() {
        return new TorgalAFineHoundEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = (Spell)this.getValue("spellCast");
        return spell != null && event.getTargetId().equals(spell.getCard().getId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        int count = xValue.calculate(game, source, (Effect)this);
        if (creature == null || count < 1) {
            return false;
        }
        creature.addCounters(CounterType.P1P1.createInstance(count), source.getControllerId(), source, game, event.getAppliedEffects());
        this.discard();
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.DOG.getPredicate(), (Predicate)SubType.WOLF.getPredicate()));
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Dogs and Wolves you control", xValue);
    }
}

