/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class TorgalAFineHoundWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    TorgalAFineHoundWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getSpell(arg_0)).filter(spell -> spell.isCreature(game) && spell.hasSubtype(SubType.HUMAN, game)).map(Spell::getControllerId).ifPresent(playerId -> this.map.compute((UUID)playerId, CardUtil::setOrIncrementValue));
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean check(Game game, Ability source) {
        return ((TorgalAFineHoundWatcher)game.getState().getWatcher(TorgalAFineHoundWatcher.class)).map.getOrDefault(source.getControllerId(), 0) < 2;
    }
}

