/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TormentorsHelmEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TormentorsHelmTriggeredAbility
extends TriggeredAbilityImpl {
    public TormentorsHelmTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private TormentorsHelmTriggeredAbility(TormentorsHelmTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TormentorsHelmTriggeredAbility copy() {
        return new TormentorsHelmTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATURE_BLOCKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        Permanent equipment = game.getPermanent(this.sourceId);
        if (equipment != null && (creature = game.getPermanent(equipment.getAttachedTo())) != null && creature.getId().equals(event.getTargetId())) {
            this.getEffects().clear();
            TormentorsHelmEffect effect = new TormentorsHelmEffect(creature.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getDefendingPlayerId(creature.getId(), game)));
            this.addEffect((Effect)effect);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature becomes blocked, it deals 1 damage to defending player.";
    }
}

