/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.cards.t.TorrentOfLavaPreventionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.GameLog;

class TorrentOfLavaGainAbilityEffect
extends GainAbilityAllEffect {
    TorrentOfLavaGainAbilityEffect() {
        super((Ability)new SimpleActivatedAbility((Effect)new TorrentOfLavaPreventionEffect(null, 0), (Cost)new TapSourceCost()), Duration.Custom, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES);
        this.staticText = "As long as {this} is on the stack, each creature has \"{T}: Prevent the next 1 damage that would be dealt to this creature by {this} this turn.\"";
    }

    private TorrentOfLavaGainAbilityEffect(TorrentOfLavaGainAbilityEffect effect) {
        super((GainAbilityAllEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(source.getSourceId());
        if (spell == null) {
            return false;
        }
        TorrentOfLavaPreventionEffect effect = new TorrentOfLavaPreventionEffect(spell.getId(), spell.getZoneChangeCounter(game));
        String idName = spell.getName() + " [" + spell.getId().toString().substring(0, 3) + "]";
        effect.setText("Prevent the next 1 damage that would be dealt to {this} by " + GameLog.getColoredObjectIdNameForTooltip((ObjectColor)spell.getColor(game), (String)idName) + " this turn");
        this.ability = new SimpleActivatedAbility((Effect)effect, (Cost)new TapSourceCost());
        return super.apply(game, source);
    }

    public TorrentOfLavaGainAbilityEffect copy() {
        return new TorrentOfLavaGainAbilityEffect(this);
    }
}

