/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class TorrentSculptorEffect
extends OneShotEffect {
    TorrentSculptorEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile an instant or sorcery card from your graveyard. Put a number of +1/+1 counters on {this} equal to half that card's mana value, rounded up.";
    }

    private TorrentSculptorEffect(TorrentSculptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TorrentSculptorEffect copy() {
        return new TorrentSculptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        targetCard.withNotTarget(true);
        player.choose(Outcome.Exile, (Target)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        int counters = card.getManaValue();
        counters = Math.floorDiv(counters, 2) + counters % 2;
        player.moveCards(card, Zone.EXILED, source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(counters), player.getId(), source, game);
        }
        return true;
    }
}

