/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TortureChamberEffect1
extends OneShotEffect {
    public TortureChamberEffect1() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to you equal to the number of pain counters on it";
    }

    private TortureChamberEffect1(TortureChamberEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public TortureChamberEffect1 copy() {
        return new TortureChamberEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            int painCounters = permanent.getCounters(game).getCount(CounterType.PAIN);
            player.damage(painCounters, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

