/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TouchOfMoongloveDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference creatureToCheck;

    public TouchOfMoongloveDelayedTriggeredAbility(MageObjectReference creatureToCheck) {
        super((Effect)new LoseLifeTargetEffect(2), Duration.EndOfTurn, false);
        this.creatureToCheck = creatureToCheck;
    }

    private TouchOfMoongloveDelayedTriggeredAbility(TouchOfMoongloveDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.creatureToCheck = ability.creatureToCheck;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().isCreature(game)) {
            boolean damageDealt = false;
            for (MageObjectReference mor : zEvent.getTarget().getDealtDamageByThisTurn()) {
                if (!mor.equals((Object)this.creatureToCheck)) continue;
                damageDealt = true;
                break;
            }
            if (damageDealt) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(zEvent.getTarget().getControllerId()));
                }
                return true;
            }
        }
        return false;
    }

    public TouchOfMoongloveDelayedTriggeredAbility copy() {
        return new TouchOfMoongloveDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature dealt damage by that creature this turn dies, its controller loses 2 life.";
    }
}

